/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./**/*.{html,js,jsx,ts,tsx}",
    "!./node_modules/**"
  ],
  safelist: [
    // Colors and backgrounds
    { pattern: /^(bg|text|border|from|via|to)-(slate|gray|zinc|neutral|stone|red|orange|amber|yellow|lime|green|emerald|teal|cyan|sky|blue|indigo|violet|purple|fuchsia|pink|rose|white|black|brand)(-|$)/ },
    { pattern: /-(50|100|200|300|400|500|600|700|800|900)$/ },
    // Spacing and sizing
    { pattern: /^(p|px|py|pt|pr|pb|pl|m|mx|my|mt|mr|mb|ml)-(\d+|px)$/ },
    { pattern: /^(w|h|min-w|min-h|max-w|max-h)-(\d+|px|full|screen|auto)$/ },
    // Flex, grid, layout
    { pattern: /^(flex|inline-flex|grid|inline-grid|block|inline-block|hidden)$/ },
    { pattern: /^(items|justify|content|place)-(start|end|center|between|around|evenly)$/ },
    { pattern: /^gap-(\d+)$/ },
    { pattern: /^grid-cols-\d+$/ },
    // Typography and effects
    { pattern: /^(font|text|tracking|leading|whitespace|break|uppercase|lowercase|capitalize|underline|line-through|no-underline)(-|$)/ },
    { pattern: /^(shadow|ring)(-|$)/ },
    // Positioning and z-index
    { pattern: /^(relative|absolute|fixed|sticky)$/ },
    { pattern: /^z-(-?\d+|auto)$/ },
    // Rounding and borders
    { pattern: /^rounded(-(none|sm|md|lg|xl|2xl|3xl|full))?$/ },
    { pattern: /^border(-(\d+))?$/ },
    // Opacity
    { pattern: /^opacity-\d+$/ },
    // Transitions and transforms
    { pattern: /^(transition|duration|ease|delay|transform|scale|rotate|translate|skew)(-|$)/ },
    // State variants
    { pattern: /^(hover:|focus:|active:|disabled:|aria-selected:|aria-expanded:)/ }
  ],
  theme: {
    extend: {
      colors: {
        brand: { DEFAULT: "#003580", 600: "#00285F" },
        accent: "#06B6D4"
      },
      fontFamily: {
        sans: [
          "Inter",
          "ui-sans-serif","system-ui","-apple-system","Segoe UI","Roboto","Helvetica Neue","Arial","Noto Sans","sans-serif"
        ]
      }
    }
  },
  plugins: [],
};
